/*** 1.   ũƮ ***/

SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS id
	, CAST(a.number AS VARCHAR)+LEFT(a.type, 1)+CAST(b.number AS VARCHAR) AS code 
INTO TB_Ptype
FROM master..spt_values A, master..spt_values B
WHERE a.type = 'P' AND b.type = 'P' 
AND a.number BETWEEN 1 AND 20 
AND b.number BETWEEN 1 AND 20

SELECT id
	, CAST(LEFT(id * n1* n2 * h1*36 ,2) AS INT) AS st1
	, CAST(LEFT(id * n1* n2 * h2*56 ,2) AS INT) AS st2
	, CAST(LEFT(id * n1* n2 * h1* h2*84 ,2) AS INT) AS st3
	, CASE WHEN id <= 200 THEN 'A' ELSE 'B' END AS lev 
INTO TB_Stype
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS id
	      , a.number AS n1
	      , b.number AS n2
	      , a.high AS h1
	      , b.high AS h2
	 FROM master..spt_values a, master..spt_values b
	 WHERE a.type = 'P' AND b.type = 'P' 
	 AND a.number BETWEEN 1 AND 20 
	 AND b.number BETWEEN 1 AND 20 
) a

CREATE TABLE TB_Ctype (id INT, c_name NVARCHAR(100))

INSERT INTO TB_Ctype 
SELECT id
	, CASE WHEN id <= 100 THEN 'A' 
	  WHEN id <= 200 THEN 'B'
	  WHEN id <= 300 THEN 'C' 
	  ELSE 'D' END AS c_name
FROM TB_Ptype

CREATE INDEX NIDX01_Ctype on TB_Ctype(id) include (c_name)
CREATE CLUSTERED INDEX CIDX_Ptype ON TB_Ptype(id)
CREATE CLUSTERED INDEX CIDX_Stype ON TB_Stype(id)
GO

CREATE FUNCTION FN_GetCname(@id INT)
RETURNS NVARCHAR(100) AS 
BEGIN 
	DECLARE @result NVARCHAR(100)
	SELECT @result = c_name FROM TB_Ctype WHERE id = @id
	RETURN @result 
END
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT * 
FROM (SELECT ROW_NUMBER() OVER (PARTITION BY c.lev ORDER BY c.st3 DESC) seq
	      , c.*
	 FROM (SELECT a.*
		   , b.st3
		   , b.lev
		   , dbo.FN_GetCname(a.id) AS cname
	       FROM TB_Ptype a JOIN TB_Stype b 
	       ON a.id = b.id
	 ) c
) d
WHERE seq <= 5
GO


/*** 6. [TO-BE]   ***/

SELECT *, dbo.FN_GetCname(d.id) AS cname
FROM (SELECT ROW_NUMBER() OVER (PARTITION BY c.lev ORDER BY c.st3 desc ) seq
	      , c.*
	 FROM (SELECT a.*
		   , b.st3
		   , b.lev
	       FROM TB_Ptype a JOIN TB_Stype b 
	       ON a.id = b.id
	 ) c
) d
WHERE seq <= 5
GO